/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.ConfigurableField;
import jace.config.Reconfigurable;
import jace.core.Computer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Configuration
implements Reconfigurable {
    public static final ConfigNode BASE;
    public static Computer emulator;
    @ConfigurableField(name="Autosave Changes", description="If unchecked, changes are only saved when the Save button is pressed.")
    public static boolean saveAutomatically;

    @Override
    public String getName() {
        return "Configuration";
    }

    @Override
    public void reconfigure() {
    }

    public static void buildTree() {
        Configuration.buildTree(BASE, new HashSet());
    }

    private static void buildTree(ConfigNode node, Set visited) {
        if (node.subject == null) {
            return;
        }
        for (Field f : node.subject.getClass().getFields()) {
            try {
                Object o = f.get(node.subject);
                if (visited.contains(o)) continue;
                if (f.isAnnotationPresent(ConfigurableField.class)) {
                    node.setRawFieldValue(f.getName(), (Serializable)o);
                    continue;
                }
                if (o == null) continue;
                if (o instanceof Reconfigurable) {
                    Reconfigurable r = (Reconfigurable)o;
                    visited.add(r);
                    ConfigNode child = node.children.get(f.getName());
                    if (child == null || !child.subject.equals(o)) {
                        child = new ConfigNode(node, r);
                        node.children.put(f.getName(), child);
                    }
                    Configuration.buildTree(child, visited);
                    continue;
                }
                if (!o.getClass().isArray()) continue;
                String fieldName = f.getName();
                Class<?> type = o.getClass().getComponentType();
                if (!Reconfigurable.class.isAssignableFrom(type)) continue;
                Reconfigurable[] r = (Reconfigurable[])o;
                visited.add(r);
                for (int i = 0; i < r.length; ++i) {
                    String childName = fieldName + i;
                    if (r[i] == null) {
                        node.children.remove(childName);
                        continue;
                    }
                    ConfigNode grandchild = node.children.get(childName);
                    if (grandchild == null || !grandchild.subject.equals(r[i])) {
                        grandchild = new ConfigNode(node, r[i]);
                        node.children.put(childName, grandchild);
                    }
                    Configuration.buildTree(grandchild, visited);
                }
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        Object fos = null;
        ObjectOutputStream oos = null;
        try {
            Configuration.applySettings(BASE);
            oos = new ObjectOutputStream(new FileOutputStream(Configuration.getSettingsFile()));
            oos.writeObject(BASE);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSettings() {
        ObjectInputStream ois = null;
        Object fis = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Configuration.getSettingsFile()));
            ConfigNode newRoot = (ConfigNode)ois.readObject();
            Configuration.applyConfigTree(newRoot, BASE);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void resetToDefaults() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public static File getSettingsFile() {
        return new File(System.getProperty("user.dir"), ".jace.conf");
    }

    public static boolean applySettings(ConfigNode node) {
        boolean hasChanged = false;
        if (node.changed) {
            Configuration.doApply(node);
            hasChanged = true;
        }
        for (ConfigNode child : node.children.values()) {
            hasChanged = Configuration.applySettings(child) || hasChanged;
        }
        if (node.equals(BASE) && hasChanged) {
            Configuration.buildTree();
        }
        return hasChanged;
    }

    private static void applyConfigTree(ConfigNode newRoot, ConfigNode oldRoot) {
        if (oldRoot == null || newRoot == null) {
            return;
        }
        oldRoot.settings = newRoot.settings;
        if (oldRoot.subject != null) {
            Configuration.doApply(oldRoot);
            Configuration.buildTree(oldRoot, new HashSet());
        }
        for (String childName : newRoot.children.keySet()) {
            System.out.println("Applying settings for " + childName);
            Configuration.applyConfigTree(newRoot.children.get(childName), oldRoot.children.get(childName));
        }
    }

    private static void doApply(ConfigNode node) {
        for (String f : node.settings.keySet()) {
            try {
                Field ff = node.subject.getClass().getField(f);
                System.out.println("Setting " + f + " to " + node.settings.get(f));
                Object val = node.settings.get(f);
                Class<?> valType = val != null ? val.getClass() : null;
                Class<?> fieldType = ff.getType();
                if (val == null || valType.equals(fieldType)) {
                    ff.set(node.subject, val);
                    continue;
                }
                System.out.println(fieldType);
                if (fieldType.equals(Integer.TYPE)) {
                    val = new Integer(String.valueOf(val));
                } else if (fieldType.equals(Short.TYPE)) {
                    val = new Short(String.valueOf(val));
                } else if (fieldType.equals(Long.TYPE)) {
                    val = new Long(String.valueOf(val));
                } else if (fieldType.equals(Byte.TYPE)) {
                    val = new Byte(String.valueOf(val));
                }
                ff.set(node.subject, val);
            }
            catch (NoSuchFieldException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            node.subject.reconfigure();
        }
        catch (Exception ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
        node.changed = false;
    }

    static {
        emulator = Computer.getComputer();
        saveAutomatically = false;
        BASE = new ConfigNode(new Configuration());
        Configuration.buildTree();
    }

    public static class ConfigNode
    implements Serializable {
        public transient ConfigNode root;
        public transient ConfigNode parent;
        public transient Reconfigurable subject;
        private Map<String, Serializable> settings;
        protected Map<String, ConfigNode> children;
        private boolean changed = false;

        public String toString() {
            if (this.subject == null) {
                return "???";
            }
            return (this.changed ? "<html><i>" : "") + this.subject.getName();
        }

        public ConfigNode(Reconfigurable subject) {
            this(null, subject);
            this.root = null;
        }

        public ConfigNode(ConfigNode parent, Reconfigurable subject) {
            this.subject = subject;
            this.settings = new TreeMap<String, Serializable>();
            this.children = new TreeMap<String, ConfigNode>();
            this.parent = parent;
            if (this.parent != null) {
                this.root = this.parent.root != null ? this.parent.root : this.parent;
            }
        }

        public void setFieldValue(String field, Serializable value) {
            if (value != null ? value.equals(this.getFieldValue(field)) : this.getFieldValue(field) == null) {
                return;
            }
            this.changed = true;
            this.setRawFieldValue(field, value);
        }

        public void setRawFieldValue(String field, Serializable value) {
            this.settings.put(field, value);
        }

        public Serializable getFieldValue(String field) {
            return this.settings.get(field);
        }

        public Set<String> getAllSettingNames() {
            return this.settings.keySet();
        }
    }

    public static class ConfigTreeModel
    implements TreeModel {
        @Override
        public Object getRoot() {
            return BASE;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof ConfigNode) {
                ConfigNode n = (ConfigNode)parent;
                return n.children.values().toArray()[index];
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof ConfigNode) {
                ConfigNode n = (ConfigNode)parent;
                return n.children.size();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof ConfigNode) {
                ConfigNode n = (ConfigNode)parent;
                ConfigNode[] c = n.children.values().toArray(new ConfigNode[0]);
                for (int i = 0; i < c.length; ++i) {
                    if (!c[i].equals(child)) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }
}

